/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.property;

import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.property.VWSIMPublishedDataPane;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VWSIMPublishedDataDialog
extends VWModalDialog
implements ActionListener {
    private Frame m_parentFrame = null;
    private JButton m_closeButton = new JButton(VWSIMResource.Close);
    private JButton m_helpButton = new JButton(VWSIMResource.Help);
    private VWSession m_vwSession = null;
    private VWSIMSession m_simSession = null;
    private VWSIMPublishedDataPane m_publlishedDataPane = null;

    public VWSIMPublishedDataDialog(Frame parent, VWSession vwSession, VWSIMSession simSession) {
        super(parent);
        try {
            this.setTitle(VWSIMResource.PublishedData);
            this.m_parentFrame = parent;
            this.m_vwSession = vwSession;
            this.m_simSession = simSession;
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("650,500");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.m_publlishedDataPane = new VWSIMPublishedDataPane(this.m_parentFrame, this.m_vwSession, this.m_simSession);
            this.m_publlishedDataPane.setVisible(true);
            this.getContentPane().add((Component)this.m_publlishedDataPane, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.m_closeButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_closeButton) {
            try {
                this.m_publlishedDataPane.saveUserPreference();
                this.setVisible(false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWSIMResource.ErrorMessage, 0);
            }
        } else if (obj == this.m_helpButton) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Config + "vwsimpublisheddatadialog.htm");
        }
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_closeButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_closeButton = null;
        this.m_helpButton = null;
        this.m_vwSession = null;
        this.m_simSession = null;
        if (this.m_publlishedDataPane != null) {
            this.m_publlishedDataPane.releaseResources();
            this.m_publlishedDataPane = null;
        }
        this.removeAll();
    }
}

